package cn.com.duiba.quanyi.center.api.dto.unionpay;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 银联卡卷表
 * @author mybatis generator 
 * @date 2025-04-23
 */
@Data
public class UnionPayActivityDto implements Serializable {
     
    private static final long serialVersionUID = 17453753369832025L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 活动名称
     */
    private String unionPayActivityName;

    /**
     * 优惠券ID
     */
    private String discountId;

    /**
     * 活动状态( 0 停用 1启用)
     */
    private String alipayActStatus;

    /**
     * 面额
     */
    private Long discountValue;

    /**
     * 门槛金额
     */
    private Long discountThresholdAmt;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 总预算
     */
    private Long totalBudget;

    /**
     * 活动规则
     */
    private String activityRule;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作名称
     */
    private String createOperatorName;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 是否逻辑删除
     */
    private Integer logicDelete;

    /**
     * 是否启用：1启用 0未启用
     */
    private Integer enableStatus;

    /**
     * 商户id
     */
    private String mchId;
}