package cn.com.duiba.quanyi.center.api.remoteservice.payment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.payment.SupplierPrepaymentDeductionDto;

import java.util.List;

/**
 * 供应商预付款抵扣远程服务接口
 * @author xuzhigang 
 * @date 2025-09-17 16:20
 */
@AdvancedFeignClient
public interface RemoteSupplierPrepaymentDeductionService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 供应商预付款抵扣
     */
    SupplierPrepaymentDeductionDto selectById(Long id);

    /**
     * 根据供应商ID查询
     * @param supplierId 供应商ID
     * @return 供应商预付款抵扣列表
     */
    List<SupplierPrepaymentDeductionDto> selectBySupplierId(Long supplierId);

    /**
     * 根据预付款ID查询
     * @param prepaymentId 预付款ID
     * @return 供应商预付款抵扣列表
     */
    List<SupplierPrepaymentDeductionDto> selectByPrepaymentId(Long prepaymentId);

    /**
     * 根据供应商付款ID查询
     * @param supplierPaymentId 供应商付款ID
     * @return 供应商预付款抵扣列表
     */
    List<SupplierPrepaymentDeductionDto> selectBySupplierPaymentId(Long supplierPaymentId);

    /**
     * 根据供应商付款编号查询
     * @param supplierPaymentNo 供应商付款编号
     * @return 供应商预付款抵扣列表
     */
    List<SupplierPrepaymentDeductionDto> selectBySupplierPaymentNo(String supplierPaymentNo);

    /**
     * 新增
     * @param dto 供应商预付款抵扣
     * @return 主键
     */
    Long insert(SupplierPrepaymentDeductionDto dto);

    /**
     * 批量新增
     * @param list 供应商预付款抵扣列表
     * @return 执行结果
     */
    Integer batchInsert(List<SupplierPrepaymentDeductionDto> list);

    /**
     * 更新
     * @param dto 供应商预付款抵扣
     * @return 执行结果
     */
    Integer update(SupplierPrepaymentDeductionDto dto);

    /**
     * 批量更新
     * @param list 供应商预付款抵扣列表
     * @return 执行结果
     */
    Integer batchUpdate(List<SupplierPrepaymentDeductionDto> list);
}
