package cn.com.duiba.quanyi.center.api.dto.pay.create;

import cn.com.duiba.quanyi.center.api.dto.pay.create.ext.PayCreateOrderResultExtDto;
import lombok.Data;

import java.io.Serializable;

/**
 * 支付下单结果
 * @author lizhi
 * @date 2023/10/22 11:48
 */
@Data
public class PayCreateOrderResultDto implements Serializable {
    
    private static final long serialVersionUID = -5010310053435641685L;
    
    /**
     * 订单号
     */
    private String bizOrderNo;

    /**
     * 下单是否成功
     */
    private Boolean success;

    /**
     * 错误码
     */
    private String failCode;

    /**
     * 下单失败原因
     */
    private String failMsg;

    /**
     * 支付渠道
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum
     */
    private String payChannelType;

    /**
     * 下单返回信息
     */
    private PayCreateOrderResultExtDto result;
}
