package cn.com.duiba.quanyi.center.api.enums.activity.common;

import cn.com.duiba.boot.exception.BizException;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2025/4/22 11:10
 */
@AllArgsConstructor
@Getter
public enum ActivityCommonErrorCodeEnum {
    AC999999("系统异常"),

    // 活动、配置 000
    AC000001("活动不存在"),
    AC000002("活动类型错误"),
    AC000003("活动扩展信息为空"),
    AC000004("扩展信息存储数据类型不对"),
    AC000005("领取周期，单位错误"),
    AC000006("黑白名单，用户唯一标记类型不一样"),
    AC000007("集合页不存在"),
    AC000008("集合页类型错误"),
    AC000009("奖品库存不存在"),
    AC000010("奖品不存在"),
    AC000011("奖品领取周期配置与数据库实际数据不符"),
    AC000012("开启了领取次数限制，但是限制明细为空"),

    // 通用用户 001
    AC001001("用户详情不存在"),
    AC001002("用户不存在"),


    // 通用校验计算结果 002
    AC002001("校验-用户校验未配置"),
    AC002002("校验-用户API权限未校验"),
    AC002003("校验-用户API权限校验未通过/异常"),
    AC002004("校验-用户定制校验未验证"),
    AC002005("校验-用户定制校验未通过/异常"),
    AC002006("校验-可访问用户类型为空"),
    AC002007("校验-用户不在可访问类型内"),
    AC002008("校验-用户在黑名单内"),
    AC002009("校验-用户不在白名单内"),
    AC002010("校验-报名配置错误"),
    AC002011("校验-报名定制校验未验证"),
    AC002012("校验-报名定制校验验证不通过/异常"),
    AC002013("校验-本期未报名"),
    AC002014("校验-无上周期"),
    AC002015("校验-上周期未报名"),
    AC002016("校验-奖品不在白名单内"),
    AC002017("校验-白名单达标-用户白名单达标金额不满足该奖品达标金额"),
    AC002018("校验-api达标-未验证"),
    AC002019("校验-api达标-未达标"),
    AC002020("校验-api达标-非达标奖品"),
    AC002022("校验-剩余次数为0"),
    AC002023("校验-不可领取原因-尚未支付"),
    AC002024("校验-不可支付原因-未开启支付"),
    AC002025("校验-在白名单内，但是没有可用的白名单记录了"),
    AC002027("校验-不可支付原因-有尚未使用的支付凭证"),
    AC002028("校验-不展示用户ID原因-未启用"),
    AC002029("校验-不展示用户ID原因-配置的用户信息暂未支持"),
    AC002030("校验-不展示用户ID原因-获取到的值为空"),
    AC002031("校验-活动未启用"),
    AC002032("校验-活动尚未开始"),
    AC002033("校验-活动已结束"),
    AC002034("校验-活动当前不在领取时间内"),
    AC002035("校验-用户领取记录缓存加载失败"),
    AC002036("校验-用户领取记录统计数据缓存加载失败"),
    AC002037("校验-用户扩展信息缓存加载失败"),
    AC002038("校验-支付阻断处理中订单，但是最近处理中订单缓存加载失败"),
    AC002039("校验-支付凭证缓存加载失败"),
    AC002040("校验-谢谢参与，不可支付"),
    AC002041("校验-不可支付原因-奖品售罄"),
    AC002042("校验-不可领取原因-没有任何奖品可领取"),
    AC002043("校验-不可支付原因-当前有可领取奖品"),
    AC002044("校验-不可支付原因-当前没有可支付奖品"),
    AC002047("校验-不可报名原因-未开启报名"),
    AC002048("校验-不可报名原因-活动当前不可访问"),
    AC002049("校验-不可报名原因-当前不在报名时间内"),
    AC002050("校验-不可报名原因-在黑名单内"),
    AC002051("校验-不可报名原因-用户校验未通过"),
    AC002052("校验-不可报名原因-本期已报名"),
    AC002053("校验-集合页用户领取记录统计数据缓存加载失败"),
    AC002054("校验-集合页用户API/定制权限校验-该活动无权限"),
    AC002055("校验-集合页校验结果为空"),
    AC002056("校验-集合页校验结果是否可领取对象为空"),
    AC002057("校验-集合页不可参与"),
    AC002058("校验-集合页已开启报名，活动将不能报名"),
    AC002059("校验-集合页活动剩余参与次数不足"),
    AC002060("校验-集合页统计数据加载失败"),
    AC002061("校验-集合页不可访问"),
    AC002062("校验-集合页当前不在领取时间内"),

    // web 用户信息加载 003
    AC003001("用户信息加载-未实现用户API校验"),
    AC003002("用户信息加载-用户API校验返回data为null"),
    AC003003("用户信息加载-未实现用户定制校验"),
    AC003004("用户信息加载-用户定制校验返回data为null"),
    AC003005("用户信息加载-未实现API达标"),
    AC003006("用户信息加载-达标API返回data为null"),
    AC003007("用户信息加载-未实现报名定制校验"),
    AC003008("用户信息加载-报名定制校验返回data为null"),
    AC003009("用户信息加载-未实现集合页用户API校验"),
    AC003010("用户信息加载-集合页用户API校验返回data为null"),
    AC003011("用户信息加载-未实现集合页用户定制校验"),
    AC003012("用户信息加载-集合页用户定制校验返回data为null"),

    // web 领取 004
    AC004001("领取-概率出奖-随机出的奖品为null"),
    AC004002("领取-活动当前不可访问"),
    AC004005("领取-用户活动剩余领取次数为null"),
    AC004006("领取-用户活动剩余领取次数不足"),
    AC004007("领取-请至少选择一个奖品"),
    AC004008("领取-奖品计算结果不存在"),
    AC004011("领取-奖品剩余领取次数为null"),
    AC004012("领取-奖品剩余领取次数不足"),
    AC004013("领取-传入的奖品ID有重复的"),
    AC004014("领取-初始化领取统计数据失败"),
    AC004016("领取-集合页配置查询失败"),
    AC004017("领取-初始化集合页领取统计数据失败"),
    AC004018("领取-集合页计算结果不存在"),
    AC004019("领取-集合页统计记录不存在"),

    // center 领取 005
    AC005001("领取-奖品ID对应奖品不存在"),
    AC005002("领取-保存领取记录失败"),
    AC005003("领取-保存领取记录异常"),
    AC005004("领取-用户领取统计更新失败"),
    AC005005("领取-支付凭证更新失败"),
    AC005006("领取-白名单扣减失败"),
    AC005007("领取-助力次数扣减失败"),
    AC005008("领取-领取商品类型超过上限"),
    AC005009("领取-奖品库存扣减失败"),
    AC005010("领取-奖品周期库存扣减失败"),
    AC005011("领取-奖品ID列表为空"),
    AC005012("领取-所有领取奖品均售罄"),

    // web 支付 006
    AC006001("支付-活动未开启支付"),
    AC006002("支付-活动当前不可访问"),
    AC006004("支付-奖品计算结果为空"),
    AC006006("支付-活动售罄"),
    AC006007("支付-奖品售罄"),
    AC006008("支付-支付金额未配置"),
    AC006009("支付-用户传入金额与实际金额不符"),
    AC006011("支付-下单返回结果为空"),
    AC006012("支付-当前还有处理中支付订单，请在上一笔支付订单处理完后再支付下一笔"),



    // center 支付 007
    AC007001("支付-支付凭证为空"),
    AC007002("支付-支付凭证保存失败"),
    AC007003("支付-活动未配置支付"),
    AC007004("支付-活动开启支付"),
    AC007005("支付-支付成功回调时，支付凭证为空"),
    AC007006("支付-支付成功回调时，奖品纬度支付，支付凭证不是只有一个"),
    AC007007("支付-支付成功回调时，奖品纬度支付，未匹配到支付"),
    AC007008("支付-支付成功回调时，卡bin验证不正确"),
    AC007009("支付-支付成功回调时，卡种验证不正确"),
    AC007010("支付-支付成功回调时，保存支付凭证失败"),

    ;
    private final String desc;

    /**
     * 根据枚举值获取枚举
     * @param name 枚举名称
     * @return 枚举
     */
    public static ActivityCommonErrorCodeEnum getByName(String name) {
        try {
            return valueOf(name);
        } catch (Exception e) {
            return null;
        }
    }

    public void throwBiz() throws BizException {
        throw new BizException(this.getDesc()).withCode(this.name());
    }
}
