package cn.com.duiba.quanyi.center.api.param.workflow;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 退款审批流发起审批参数
 * @author yangyukang
 * @date 2025/1/21
 */
@Data
public class RefundWorkflowStartApprovalProcessParam implements Serializable {

    private static final long serialVersionUID = 8472639184756291848L;

    /**
     * 退款变更记录ID
     */
    @NotNull(message = "退款变更记录ID不能为空")
    private Long refundChangeRecordId;

    /**
     * 当前用户部门ID
     */
    @NotNull(message = "部门ID不能为空")
    private Long deptId;

    /**
     * 发起人用户ID
     */
    @NotNull(message = "发起人用户ID不能为空")
    private String originatorUserId;

    /**
     * 发起人sso用户ID
     */
    @NotNull(message = "发起人sso用户ID不能为空")
    private Long initiatorSsoId;

    /**
     * 审批额外参数extParam
     */
    private String extParam;
}
