package cn.com.duiba.quanyi.center.api.remoteservice.user;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.UserExtCommonDto;

/**
 * 用户通用扩展信息表
 * @author kjj mybatis generator
 * @date 2025-04-15
 */
@AdvancedFeignClient
public interface RemoteUserExtCommonService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户通用扩展信息
     */
    UserExtCommonDto selectById(Long id);

    /**
     * 根据userId查询（redis缓存）
     * @param userId 用户ID
     * @return key:枚举，value：对应的值
     */
    Map<Integer, String> selectByUserCache(Long userId);

    /**
     * 根据userId查询列表
     * @param userId 用户ID
     * @return 用户通用扩展信息列表
     */
    List<UserExtCommonDto> selectListByUser(Long userId);

    /**
     * 根据扩展键和扩展值查询
     * @param extKey 扩展键
     * @param extVal 扩展值
     * @return 用户通用扩展信息列表
     */
    List<UserExtCommonDto> selectByExtKeyAndExtVal(Integer extKey, String extVal);

    /**
     * 批量新增或更新
     * @param userId 用户ID
     * @param list 用户通用扩展信息
     * @return 执行结果
     */
    int batchInsertOrUpdate(Long userId, List<UserExtCommonDto> list);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据用户ID列表查询
     * @param userIds 用户ID列表
     * @return 用户通用扩展信息列表
     */
    List<UserExtCommonDto> selectByUserIds(List<Long> userIds);

    /**
     * 根据用户ID列表和扩展键查询
     * @param userIds 用户ID列表
     * @param extKey 扩展键
     * @return 用户通用扩展信息列表
     */
    List<UserExtCommonDto> selectByUserIdsAndExtKey(List<Long> userIds, Integer extKey);
}
