package cn.com.duiba.quanyi.center.api.remoteservice.demandorder;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demandorder.DemandOrderDetailDto;
import cn.com.duiba.quanyi.center.api.param.demandorder.DemandOrderDetailSearchParam;
import java.util.List;

/**
 * 需求单明细
 * @author kjj mybatis generator 
 * @date 2025-05-13
 */
@AdvancedFeignClient
public interface RemoteDemandOrderDetailService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 需求单明细集合
     */
    List<DemandOrderDetailDto> selectPage(DemandOrderDetailSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(DemandOrderDetailSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 需求单明细
     */
    DemandOrderDetailDto selectById(Long id);

    /**
     * 新增
     * @param dto 需求单明细
     * @return 执行结果
     */
    int insert(DemandOrderDetailDto dto);

    /**
     * 更新
     * @param dto 需求单明细
     * @return 影响行数
     */
    int update(DemandOrderDetailDto dto);
}