package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2025/7/11 14:43
 */
@Getter
@AllArgsConstructor
public enum SettlementStatIdTypeEnum {
    CONTRACT(1, "结算单关联合同"),
    DEMAND(2, "结算单关联需求"),
    STAT(3, "日统计数据"),
    SUPPLIER_INBOUND(4, "供应商入库单"),
    PRE(5, "预结算"),
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, SettlementStatIdTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SettlementStatIdTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static SettlementStatIdTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
