package cn.com.duiba.quanyi.center.api.param.qystatistic;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 运营工作台-消耗数据统计表
 * @author mybatis generator
 * @date 2025-06-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ConsumeStatisticSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17491225401668473L;

    /**
     * 统计类型
     * @see cn.com.duiba.quanyi.center.api.enums.statistic.ConsumeStatisitcTypeEnum
     */
    private Integer statType;

    /**
     * 对应活动、奖品、需求...创建人id
     */
    private Long createOperatorId;

    /**
     * stat_type为2,4时有值，对应活动id，需求id
     */
    private String parentStatId;

    /**
     * 是否异常 0=正常，1=异常
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer abnormalFlag;

    /**
     * 活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 统计日期
     */
    private Date statDate;

}
