package cn.com.duiba.quanyi.center.api.dto.mall.address;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商城用户收货地址
 * @author mybatis generator 
 * @date 2024-05-24
 */
@Data
public class MallUserAddressDto implements Serializable {
     
    private static final long serialVersionUID = 17165450950852189L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 是否已删除：0-未删除，1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 是否为默认地址
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer defaultAddress;

    /**
     * 用户姓名
     */
    private String userName;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 省份
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区、县
     */
    private String district;

    /**
     * 街道
     */
    private String street;

    /**
     * 详细地址
     */
    private String address;
}