/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.activity.common;

import cn.com.duiba.quanyi.center.api.dto.common.ActivityPeriodicDto;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ActivityPeriodicUnitEnum {
    FOREVER(1, "\u6c38\u4e45"),
    ABSOLUTE(2, "\u7edd\u5bf9\u65f6\u95f4"),
    DAY(3, "\u65e5"),
    WEEK(4, "\u81ea\u7136\u5468"),
    MONTH(5, "\u81ea\u7136\u6708"),
    QUARTER(6, "\u5b63\u5ea6");

    private final Integer code;
    private final String desc;
    private static final Date FOREVER_DATE_BEGIN;
    private static final Date FOREVER_DATE_END;
    private static final Map<Integer, ActivityPeriodicUnitEnum> ENUM_MAP;

    public ActivityPeriodicDto getDate(Date now, Date absoluteStartTime, Date absoluteEndTime) {
        switch (this) {
            case FOREVER: {
                return new ActivityPeriodicDto("20000101", FOREVER_DATE_BEGIN, FOREVER_DATE_END);
            }
            case ABSOLUTE: {
                return new ActivityPeriodicDto(DatePattern.PURE_DATE_FORMAT.format(absoluteStartTime), absoluteStartTime, absoluteEndTime);
            }
            case DAY: {
                return new ActivityPeriodicDto(DatePattern.PURE_DATE_FORMAT.format((Date)DateUtil.beginOfDay((Date)now)), (Date)DateUtil.beginOfDay((Date)now), (Date)DateUtil.endOfDay((Date)now));
            }
            case WEEK: {
                return new ActivityPeriodicDto(DatePattern.PURE_DATE_FORMAT.format((Date)DateUtil.beginOfWeek((Date)now)), (Date)DateUtil.beginOfWeek((Date)now), (Date)DateUtil.endOfWeek((Date)now));
            }
            case MONTH: {
                return new ActivityPeriodicDto(DatePattern.PURE_DATE_FORMAT.format((Date)DateUtil.beginOfMonth((Date)now)), (Date)DateUtil.beginOfMonth((Date)now), (Date)DateUtil.endOfMonth((Date)now));
            }
            case QUARTER: {
                return new ActivityPeriodicDto(DatePattern.PURE_DATE_FORMAT.format((Date)DateUtil.beginOfQuarter((Date)now)), (Date)DateUtil.beginOfQuarter((Date)now), (Date)DateUtil.endOfQuarter((Date)now));
            }
        }
        return null;
    }

    public ActivityPeriodicDto getCurrentPeriod() {
        return this.getDate(new Date(), null, null);
    }

    public ActivityPeriodicDto getOffsetPeriod(int offset) {
        Date now = new Date();
        switch (this) {
            case DAY: {
                now = DateUtil.offsetDay((Date)now, (int)offset);
                break;
            }
            case WEEK: {
                now = DateUtil.offsetWeek((Date)now, (int)offset);
                break;
            }
            case MONTH: {
                now = DateUtil.offsetMonth((Date)now, (int)offset);
                break;
            }
            case QUARTER: {
                now = DateUtil.offsetMonth((Date)now, (int)(offset * 3));
                break;
            }
        }
        return this.getDate(now, null, null);
    }

    public static List<ActivityPeriodicUnitEnum> getPeriodTakeEnums() {
        return Arrays.asList(DAY, WEEK, MONTH, QUARTER);
    }

    public static ActivityPeriodicUnitEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    private ActivityPeriodicUnitEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        FOREVER_DATE_BEGIN = DateUtils.getDayDate((String)"2000-01-01");
        FOREVER_DATE_END = DateUtils.getDayDate((String)"2099-01-01");
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ActivityPeriodicUnitEnum.values()).collect(Collectors.toMap(ActivityPeriodicUnitEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    }
}

