package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/11/25 17:39
 */
@AllArgsConstructor
@Getter
public enum SettlementClassificationEnum {
    SETTLEMENT(1, "结算单"),
    PREPAYMENT(2, "预付款"),
    CUSTOM(3, "自定义"),
    SETTLEMENT_DIGITAL(4, "结算单-数字营销"),
    PREPAYMENT_WITH_DEFERRED_INVOICE(5, "预付款-结算时开票"),
    SUPPLIER_PAYMENT(6, "供应商付款"),
    PRE(7, "预结算结算单"),
    ;
    private final Integer type;

    private final String desc;

    public static boolean isSettlement(Integer type) {
        return SETTLEMENT.getType().equals(type) || SETTLEMENT_DIGITAL.getType().equals(type);
    }

    public static boolean isPrepayment(Integer type) {
        return PREPAYMENT.getType().equals(type) || PREPAYMENT_WITH_DEFERRED_INVOICE.getType().equals(type);
    }
}
