/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.project;

import cn.com.duiba.quanyi.center.api.enums.contract.BusinessGroupTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BelongingBusinessTypeEnum {
    BANK_CHANNEL_BUSINESS(1, "\u94f6\u884c\u6e20\u9053", BusinessGroupTypeEnum.RIGHTS),
    INSURANCE_BUSINESS(2, "\u4fdd\u9669\u4e1a\u52a1", BusinessGroupTypeEnum.RIGHTS),
    INNOVATION_BUSINESS(3, "\u521b\u65b0\u4e1a\u52a1", BusinessGroupTypeEnum.RIGHTS),
    DIGITAL_MARKETING(4, "\u6570\u5b57\u8425\u9500", BusinessGroupTypeEnum.DIGITAL);

    private final Integer type;
    private final String desc;
    private final BusinessGroupTypeEnum businessGroup;
    private static final Map<String, BelongingBusinessTypeEnum> DESC_ENUM_MAP;

    public static boolean isNeedWorkflowType(Integer type) {
        return BANK_CHANNEL_BUSINESS.getType().equals(type) || INSURANCE_BUSINESS.getType().equals(type);
    }

    public static BelongingBusinessTypeEnum getEnumByDesc(String desc) {
        return DESC_ENUM_MAP.get(desc);
    }

    public static BelongingBusinessTypeEnum getEnum(Integer type) {
        for (BelongingBusinessTypeEnum enumItem : BelongingBusinessTypeEnum.values()) {
            if (!enumItem.getType().equals(type)) continue;
            return enumItem;
        }
        return null;
    }

    public static String getDescByType(Integer type) {
        BelongingBusinessTypeEnum enumItem = BelongingBusinessTypeEnum.getEnum(type);
        if (enumItem != null) {
            return enumItem.getDesc();
        }
        return null;
    }

    public static List<Integer> getListByGroup(Integer businessGroup) {
        return Arrays.stream(BelongingBusinessTypeEnum.values()).filter(item -> item.getBusinessGroup().getType().equals(businessGroup)).map(BelongingBusinessTypeEnum::getType).collect(Collectors.toList());
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public BusinessGroupTypeEnum getBusinessGroup() {
        return this.businessGroup;
    }

    private BelongingBusinessTypeEnum(Integer type, String desc, BusinessGroupTypeEnum businessGroup) {
        this.type = type;
        this.desc = desc;
        this.businessGroup = businessGroup;
    }

    static {
        DESC_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(BelongingBusinessTypeEnum.values()).collect(Collectors.toMap(BelongingBusinessTypeEnum::getDesc, Function.identity(), (v1, v2) -> v2)));
    }
}

