package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 供应商统计表
 *
 * @author xuzhigang
 * @date 2025-09-18 15:50
 */
@Data
public class SupplierStatDto implements Serializable {

    private static final long serialVersionUID = 8429517364829517L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 统计纬度ID，类型=1-供应商id
     */
    private String statId;

    /**
     * 统计纬度类型：1-供应商维度
     */
    private Integer statType;

    /**
     * 总采购金额
     */
    private Long totalAmount;

    /**
     * 总已付款金额
     */
    private Long totalActualPaymentAmount;

    /**
     * 总付款中金额
     */
    private Long totalPaymentAmount;

    /**
     * 总未付款金额
     */
    private Long totalUnpaidAmount;

    /**
     * 总已开票金额
     */
    private Long totalInvoicedAmount;

    /**
     * 总剩余金额
     */
    private Long totalSurplusAmount;
}
