package cn.com.duiba.quanyi.center.api.param.template;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 模板字段表
 * @author mybatis generator 
 * @date 2025-03-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class TemplateFieldSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 1742883612179310L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 模板ID
     */
    private Long templateDefinitionId;

    /**
     * 字段编码
     */
    private String fieldCode;

    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 字段类型(string/number/boolean/object/array)
     */
    private String fieldType;

    /**
     * 父级字段编码
     */
    private String parentCode;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否删除 0:未删除 1:已删除
     */
    private Integer isDeleted;
}