package cn.com.duiba.quanyi.center.api.remoteservice.product;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.product.ProductDto;
import cn.com.duiba.quanyi.center.api.param.product.ProductListSearchParam;
import cn.com.duiba.quanyi.center.api.param.product.ProductSearchParam;
import java.util.List;

/**
 * 数字营销产品
 * @author kjj mybatis generator 
 * @date 2025-06-11
 */
@AdvancedFeignClient
public interface RemoteProductService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 数字营销产品集合
     */
    List<ProductDto> selectPage(ProductSearchParam param);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param productName 产品名称
     * @param productType 产品类型
     * @return 数字营销产品集合
     */
    List<ProductDto> selectByNameAndType(String productName, Integer productType);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ProductSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 数字营销产品
     */
    ProductDto selectById(Long id);

    /**
     * 新增或更新产品
     * @param dto 数字营销产品
     * @return 产品ID
     */
    Long saveOrUpdate(ProductDto dto) throws BizException;

    /**
     * 更新启用状态
     * @param dto 数字营销产品
     * @return 是否成功
     */
    int updateEnableStatus(ProductDto dto);
}