package cn.com.duiba.quanyi.center.api.dto.ccb.billpush;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 建行账单文件推送明细 DTO，对应表：tb_ccb_bill_push_detail。
 *
 * <p>包含任务ID、文件URL、批次号、推送状态、重试次数等字段。</p>
 *
 * @author zzy
 * @since 2025-09-25 10:30
 */
@Data
public class CcbBillPushDetailDto implements Serializable {

    private static final long serialVersionUID = 1432659821736502983L;

    /**
     * 推送状态枚举。
     */
    public enum StatusEnum {
        /**
         * 待推送。
         */
        NOT_PUSH(1),
        /**
         * 推送中。
         */
        PUSHING(2),
        /**
         * 等待反馈。
         */
        WAIT_FEEDBACK(3),
        /**
         * 推送成功。
         */
        PUSH_SUCCESS(4),
        /**
         * 推送失败。
         */
        PUSH_FAIL(5);
        private Integer value;

        StatusEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return value;
        }
    }

    /**
     * 主键ID。
     */
    private Long id;
    /**
     * 任务ID。对应字段：task_id。
     */
    private Long taskId;
    /**
     * OSS文件URL。对应字段：file_url。
     */
    private String fileUrl;
    /**
     * 建行返回的批次号。对应字段：batch_num。
     */
    private String batchNum;
    /**
     * 推送状态：1-待推送、2-推送中、3-等待反馈、4-推送成功、5-推送失败。对应字段：push_status。
     */
    private Integer pushStatus;
    /**
     * 重试次数。对应字段：retry_count。
     */
    private Integer retryCount;
    /**
     * 创建时间。对应字段：gmt_create。
     */
    private Date gmtCreate;
    /**
     * 修改时间。对应字段：gmt_modified。
     */
    private Date gmtModified;
}


