package cn.com.duiba.quanyi.center.api.dto.cardsecret;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 卡密回退任务DTO
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@Data
public class CardSecretRefundTaskDto implements Serializable {

    private static final long serialVersionUID = -8472639184756291848L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 总提交回退数量
     */
    private Long totalRefundNum;

    /**
     * 已回退数量
     */
    private Long refundedNum;

    /**
     * 是否结算：0-未结算，1-已结算
     */
    private Integer isSettled;

    /**
     * 回退原因
     */
    private String refundReason;

    /**
     * 回退任务状态：1-待处理，2-处理中，3-已完成，4-已失败，5-已取消
     */
    private Integer refundTaskStatus;

    /**
     * 审批状态
     */
    private Integer approvalStatus;

    /**
     * 审批流程实例ID
     */
    private Long workflowInstanceId;

    /**
     * 发起失败原因
     */
    private String submitFailReason;

    /**
     * 发起人SSO用户ID
     */
    private Long operatorSsoId;

    /**
     * 发起人SSO姓名
     */
    private String operatorSsoName;

    /**
     * 发起人钉钉用户ID
     */
    private String dingTalkUserId;

    /**
     * 发起人部门ID（钉钉部门ID）
     */
    private Long dingTalkDeptId;
}

