package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.QuanYiPsbcRsBillDetailDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.QuanYiPsbcRsBillDetailSearchParam;
import java.util.List;

/**
 * 邮储荣数账单明细
 * @author kjj mybatis generator 
 * @date 2025-08-19
 */
@AdvancedFeignClient
public interface RemoteQuanYiPsbcRsBillDetailService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 邮储荣数账单明细集合
     */
    List<QuanYiPsbcRsBillDetailDto> selectPage(QuanYiPsbcRsBillDetailSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(QuanYiPsbcRsBillDetailSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 邮储荣数账单明细
     */
    QuanYiPsbcRsBillDetailDto selectById(Long id);

    /**
     * 新增
     * @param dto 邮储荣数账单明细
     * @return 执行结果
     */
    int insert(QuanYiPsbcRsBillDetailDto dto);

    /**
     * 更新
     * @param dto 邮储荣数账单明细
     * @return 影响行数
     */
    int update(QuanYiPsbcRsBillDetailDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}