package cn.com.duiba.quanyi.center.api.dto.cardsecret;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 卡密回退任务明细DTO
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@Data
public class CardSecretRefundTaskDetailDto implements Serializable {

    private static final long serialVersionUID = -7021365984132578901L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 任务ID（关联主表tb_card_secret_refund_task.id）
     */
    private Long taskId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 批次号（卡密批次ID）
     */
    private Long batchId;

    /**
     * 关联记录ID
     */
    private Long relatedRecordId;

    /**
     * 提交回退数量
     */
    private Long submitRefundNum;

    /**
     * 最终回退数量
     */
    private Long finalRefundNum;

    /**
     * 唯一编码
     */
    private String uniqueCode;

    /**
     * 回退明细状态：1-待处理，2-处理中，3-已完成，4-已失败，5-已取消
     */
    private Integer refundDetailStatus;
}

