package cn.com.duiba.quanyi.center.api.param.deposit;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 保证金保存/编辑参数
 * @author xuzhigang
 * @date 2025-09-02
 */
@Data
public class PaymentInfoDepositSaveParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 保证金记录ID（编辑时必填） -> tb_payment_info_deposit.id
     */
    private Long id;

    /**
     * 创建人ID（ssoId）
     */
    private Long createOperatorId;

    /**
     * 创建人姓名（ssoName）
     */
    private String createOperatorName;

    /**
     * 投标名称：20 字以内
     */
    private String bidName;

    /**
     * 付款事由：30 字以内
     */
    private String paymentReason;

    /**
     * 付款总额
     */
    private Long paymentAmount;

    /**
     * 打款公司选项ID
     */
    private Long paymentCompanyOptionsId;

    /**
     * 付款方式选项ID（银行卡、支付宝、其他）
     */
    private Long paymentTypeOptionsId;

    /**
     * 开户行（客户收款银行）
     */
    private String openingBank;

    /**
     * 收款公司
     */
    private String receivingCompany;

    /**
     * 收款账号
     */
    private String receivingAccount;

    /**
     * 开标日期（精确到天）
     */
    private Date biddingDate;

    /**
     * 预计回款日期（精确到天，且不能早于当前日期）
     */
    private Date expectedReceivedDate;

    /**
     * 招标文件（必填，仅支持 1 份文件）
     */
    private String biddingFileUrl;

    /**
     * 业务组类型，1-权益，2-数字营销
     * @see cn.com.duiba.quanyi.center.api.enums.contract.BusinessGroupTypeEnum
     */
    private Integer businessGroup;
}
