package cn.com.duiba.quanyi.center.api.bean.ccb.response;

import cn.com.duiba.quanyi.center.api.utils.sm.CcbSm4Util;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2024/11/20 14:30
 **/
@Data
public class CcbSiChuanResponse implements Serializable {
    private static final long serialVersionUID = 6873143480071938613L;

    /**
     * SM4(返回参数)
     */
    private String resData;

    public static CcbSiChuanResponse buildResponse(String sm4Key, String data) {
        CcbSiChuanResponse response = new CcbSiChuanResponse();
        response.setResData(CcbSm4Util.sm4Enc(data, sm4Key));
        return response;
    }
}
