package cn.com.duiba.quanyi.center.api.remoteservice.insurance.verify;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.insurance.InsuranceAlipayRealNameDto;
import cn.com.duiba.quanyi.center.api.param.qy.insurance.InsuranceAlipayReadlNameSearchParam;
import java.util.List;

/**
 * 保险支付宝实名表
 * @author kjj mybatis generator
 * @date 2025-06-12
 */
@AdvancedFeignClient
public interface RemoteInsuranceAlipayRealNameService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保险支付宝实名集合
     */
    List<InsuranceAlipayRealNameDto> selectPage(InsuranceAlipayReadlNameSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceAlipayReadlNameSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保险支付宝实名
     */
    InsuranceAlipayRealNameDto selectById(Long id);


    /**
     * 根据用户ID 查询用户实名成功的支付宝信息
     * @param userId
     * @return
     */
    InsuranceAlipayRealNameDto selectByUserIdAndCompanyId(Long userId,Long companyId);
    /**
     * 根据 验证ID 查询用户实名成功的支付宝信息
     * @param verifyId
     * @return
     */
    InsuranceAlipayRealNameDto selectByVerifyId(String verifyId);
    /**
     * 新增
     * @param dto 保险支付宝实名
     * @return 执行结果
     */
    int insert(InsuranceAlipayRealNameDto dto);

    /**
     * 保存或更新 只针对 用户ID 实名 验证ID进行更新保存
     * @param dto 保险支付宝实名
     * @return 影响行数
     */
    int saveOrUpdate(InsuranceAlipayRealNameDto dto);

    /**
     * 更新
     * @param dto 保险支付宝实名
     * @return 影响行数
     */
    int update(InsuranceAlipayRealNameDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
