package cn.com.duiba.quanyi.center.api.enums.invoice;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 发票类型枚举
 *
 * @author yangyukang
 * @date 2025-01-16 14:30
 */
@AllArgsConstructor
@Getter
public enum InvoiceTypeEnum {

    /**
     * 普票
     */
    GENERAL(1, "普票"),

    /**
     * 专票6
     */
    SPECIAL_6(2, "专票6"),

    /**
     * 专票13
     */
    SPECIAL_13(3, "专票13");

    /**
     * 发票类型编码
     */
    private final Integer code;

    /**
     * 发票类型描述
     */
    private final String desc;

    /**
     * 根据编码获取枚举
     *
     * @param code 编码
     * @return 对应的枚举，如果不存在返回null
     */
    public static InvoiceTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (InvoiceTypeEnum invoiceType : values()) {
            if (invoiceType.getCode().equals(code)) {
                return invoiceType;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        InvoiceTypeEnum invoiceType = getByCode(code);
        return invoiceType == null ? null : invoiceType.getDesc();
    }
}
