package cn.com.duiba.quanyi.center.api.remoteservice.alipay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.alipay.AlipayActivityBillDownloadRecordDto;
import cn.com.duiba.quanyi.center.api.param.activity.AlipayActivityBillDownloadRecordEntityParam;

import java.util.List;
import java.util.Set;

/**
 * 支付宝立减金账单数据下载记录表
 * @author kjj mybatis generator 
 * @date 2024-06-20
 */
@AdvancedFeignClient
public interface RemoteAlipayActivityBillDownloadRecordService {

    /**
     * 根据查询条件统计符合条件的数据总数
     * @param param 查询参数
     * @return 符合条件的数据总数
     */
    long selectCount(AlipayActivityBillDownloadRecordEntityParam param);

    /**
     * 根据查询条件查询符合条件的数据列表
     * @param param 查询参数
     * @return 符合条件的数据列表
     */
    List<AlipayActivityBillDownloadRecordDto> selectPage(AlipayActivityBillDownloadRecordEntityParam param);


    /**
     * 根据主键查询
     * @param ids 主键
     * @return 符合条件的数据列表
     */
    List<AlipayActivityBillDownloadRecordDto> selectByIds(List<Long> ids);


    /**
     * 根据主键更新
     * @param dto 主键
     * @return 是否更新成功
     */
    int update(AlipayActivityBillDownloadRecordDto dto);


    /**
     * 根据ID批量更新
     */
    int batchUpdate(List<AlipayActivityBillDownloadRecordDto> list);

    /**
     * 插入
     */
    int insert(AlipayActivityBillDownloadRecordDto dto);
}