package cn.com.duiba.quanyi.center.api.remoteservice.user;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.UserExtOaDto;
import cn.com.duiba.quanyi.center.api.dto.user.UserExtOaOptDto;

/**
 * 用户关联的小程序和公众号
 * @author lizhi
 * @date 2023/5/16 3:34 PM
 */
@AdvancedFeignClient
public interface RemoteUserExtOaService {

    /**
     * 新增或保存
     * @param dto 关联信息
     * @return 执行结果
     */
    int saveOrUpdate(UserExtOaDto dto);

    /**
     * 根据openId查询，redis缓存，变更时清除缓存
     * @param openId 用户openId
     * @return 用户关联信息
     */
    @Deprecated
    UserExtOaDto selectByOpenIdCache(String openId);

    /**
     * 根据id查询，redis缓存，变更时清除缓存
     * @param id 主键ID
     * @return 用户关联信息
     */
    UserExtOaDto selectById(Long id);

    /**
     * 根据openId查询，redis缓存，变更时清除缓存
     *
     * @param openId 用户openId
     * @param userType 用户类型
     * @see cn.com.duiba.quanyi.center.api.enums.user.UserTypeEnum
     * @return 用户关联信息
     */
    UserExtOaDto selectByOpenIdAndUserTypeCache(String openId, Integer userType);

    /**
     * 根据userId 和 oaId 查询，redis缓存
     * @param userId 用户Id
     * @param oaId oaId
     * @return 用户关联信息
     */
    UserExtOaDto selectByUserIdAndOaIdCache(Long userId, Long oaId);

    /**
     * 根据userId
     * @param userId 用户Id
     * @return 用户关联信息
     */
    List<UserExtOaDto> selectRecordByUserId(Long userId);

    /**
     * 根据userId列表
     * @param userIdList 用户Id列表
     * @return 用户关联信息
     */
    List<UserExtOaDto> selectRecordByUserIdList(List<Long> userIdList);

    /**
     * 查询删除的绑定关系流水记录
     * @param userId 用户ID
     * @return 删除的流水记录
     */
    List<UserExtOaOptDto> selectDeletedRelationRecord(Long userId);

    /**
     * 删除绑定关系并记录操作流水记录
     * @param id 需要删除的主键OA关联关系主键ID
     * @param userExtOaOptDto 需要记录的数据
     */
    void deleteRelationAndRecord(Long id, UserExtOaOptDto userExtOaOptDto);

    /**
     * 更新关注状态
     * @param id 主键
     * @param subscribe 关注状态
     * @return  执行结果
     */
    int updateUserSubscribe(Long id, Integer subscribe);

    /**
     * 根据userId 和 oaId 查询
     * @param userId 用户Id
     * @param oaId oaId
     * @return 用户关联的小程序和公众号信息
     */
    UserExtOaDto getByUserIdAndOaIdNoNullCache(Long userId, Long oaId);
}
