package cn.com.duiba.quanyi.center.api.enums.activity;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动库存告警类型枚举
 * 
 * @author yangyukang
 * @date 2024-12-19
 */
@Getter
@AllArgsConstructor
public enum ActivityStockWarnTypeEnum {

    /**
     * 活动库存告警
     */
    ACTIVITY_STOCK_WARN(1, "活动库存告警"),

    /**
     * 奖品库存告警
     */
    PRIZE_STOCK_WARN(2, "奖品库存告警"),
    ;

    /**
     * 数据库存储值
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, ActivityStockWarnTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityStockWarnTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static ActivityStockWarnTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 根据枚举值获取描述
     * @param type 枚举值
     * @return 描述
     */
    public static String getDescByType(Integer type) {
        ActivityStockWarnTypeEnum enumValue = getByType(type);
        return enumValue != null ? enumValue.getDesc() : null;
    }
} 