package cn.com.duiba.quanyi.center.api.dto.dayan.demand;

import java.io.Serializable;
import java.util.List;

import cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum;
import lombok.Data;

/** 
 * @author xuzhigang
 * @date 2025/11/5 16:09
 **/
@Data
public class DayanDemandGoodsDto implements Serializable {
    private static final long serialVersionUID = -1376017802012223066L;

    /**
     * 需求商品id
     */
    private Long id;

    /**
     * 商品名称
     */
    private String purchaseSpuName;

    /**
     * 商品编码
     */
    private Long purchaseSpuId;

    /**
     * 面额类型 1-定额 2-不定额
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum
     */
    private Integer amountType;

    /**
     * 面额
     */
    private Long amount;

    /**
     * 结算费率
     */
    private String settlementRate;

    /**
     * 结算单价
     */
    private Long settlementPrice;

    /**
     * 商品主图链接，多张图用英文 逗号 分割
     */
    private String mainImgs;

    /**
     * 商品详情图链接，多张图用英文 逗号 分割
     */
    private String detailImgs;

    /**
     * 商品备注
     */
    private String purchaseSpuRemark;

    /**
     * 卡密批次明细
     */
    private List<DayanCardSecretStockDto> cardSecretStockList;

    /**
     * api奖品id
     */
    private String specId;

    /**
     * 商品类型
     * @see SpuTypeEnum
     */
    private Integer spuTyp;

    /**
     * 商品描述
     */
    private String purchaseSpuDesc;
}
