package cn.com.duiba.quanyi.center.api.param.questionnaire;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2025/10/28 18:22
 */
@Data
public class QuestionnaireSubmitAnswersParam implements Serializable {

    private static final long serialVersionUID = 6363651551277555827L;

    /**
     * 题目Id
     */
    private Long questionId;

    /**
     * 题目类型（1-单选，2-多选，3-文本）
     * @see cn.com.duiba.quanyi.center.api.enums.questionnaire.QuestionnaireQuestionTypeEnum
     */
    private Integer questionType;

    /**
     * 答案
     */
    private String answerValue;

    /**
     * 选项列表
     */
    private List<QuestionnaireSubmitOptionsParam> optionsList;
}
