package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum ActivityLimitConfigEnum {

    DAY(0, "日"),

    WEEK(1, "自然周"),

    MONTH(2, "自然月"),

    FOREVER(3, "永久"),

    QUARTER(4,"季度"),

    ;

    private final Integer type;

    private final String desc;

    public static ActivityLimitConfigEnum getEnumByType(Integer type) {
        for (ActivityLimitConfigEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

}
