package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 领取时间限制配置DTO
 * 用于JSON序列化/反序列化，存储在 prizeExt 表的 confValue 字段中
 * 
 * @author yangyukang
 * @date 2025-01-21
 */
@Data
public class ClaimTimeLimitDto implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 限制类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ClaimTimeLimitTypeEnum
     */
    private Integer limitType;
    
    /**
     * 最晚可领取时间（limitType=1时使用）
     */
    private Date latestClaimTime;
    
    /**
     * 订单生成后天数（limitType=2时使用，0-99999）
     */
    private Integer daysAfterOrder;
    
    /**
     * 订单生成后当月号数（limitType=3时使用，1-31）
     */
    private Integer monthDayAfterOrder;
    
    /**
     * 自定义开始时间（limitType=5时使用）
     */
    private Date customStartTime;
    
    /**
     * 自定义结束时间（limitType=5时使用）
     */
    private Date customEndTime;
}

