package cn.com.duiba.quanyi.center.api.dto.settlement;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 结算单
 * @author mybatis generator
 * @date 2024-11-30
 */
@Data
public class SettlementDto implements Serializable {

    private static final long serialVersionUID = 1732951219864355L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 商品类型：1-非垫资，2-垫资
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementGoodsTypeEnum
     */
    private Integer goodsType;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 对接人ID，多个以英文逗号分隔
     */
    private String contactsIds;

    /**
     * 实际结算对接人
     */
    private Long settlementContactsId;

    /**
     * 结算需求ID，多个以英文逗号分隔
     */
    private String demandIds;

    /**
     * 结算方式
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementTypeEnum
     */
    private Integer settlementType;

    /**
     * 结算周期-开始时间
     */
    private Date startDate;

    /**
     * 结算周期-结束时间
     */
    private Date endDate;

    /**
     * 结算单名称
     */
    private String settlementName;

    /**
     * 方案key
     */
    private String programmeKey;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 应收金额，单位分
     */
    private Long receivableAmount;

    /**
     * 结算金额，单位分
     */
    private Long settlementAmount;

    /**
     * 明细文件地址
     */
    private String orderDetailUrl;

    /**
     * 容差金额
     */
    private Long toleranceAmount;

    /**
     * 容差备注
     */
    private String toleranceRemark;

    /**
     * 结算单状态：1-创建中，2-创建失败，3-待开票，4-部分开票，5-已开票待回款，6-已回款
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatusEnum
     */
    private Integer settlementStatus;

    /**
     * 商品数量
     */
    private Long goodsNum;

    /**
     * 商品唯一标记数量
     */
    private Long uniqueMarkNum;

    /**
     * 锁定状态: 1-未锁定，2-锁定中，3-锁定成功，4-锁定失败，5-解锁中，6-解锁成功，7-解锁失败
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementLockStatusEnum
     */
    private Integer lockStatus;

    /**
     * 已申请金额
     */
    private Long applyAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 错误描述
     */
    private String errMsg;

    /**
     * 最近一个发票申请ID
     */
    private Long lastInvoiceApplyId;

    /**
     * 汇总金额容差金额
     */
    private Long sumToleranceAmount;

    /**
     * 结算分类
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementClassificationEnum
     */
    private Integer settlementClassification;

    /**
     * 预付款使用规则：1-项目下全部对接人可用，2-指定对接人可用
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.prepayment.PrepaymentUsageRulesEnum
     */
    private Integer prepaymentUsageRules;

    /**
     * 附件
     */
    private String settlementAttachment;

    /**
     * 预付款已抵扣金额，单位分
     */
    private Long deductionAmount;

    /**
     * 退款中金额，单位分
     */
    private Long refundingAmount;

    /**
     * 已退款金额，单位分
     */
    private Long refundedAmount;

    /**
     * 所属合同ID
     */
    private Long contractId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 剩余可申请开票金额
     * @return 剩余可开票金额
     */
    public Long getSurplusApplyAmount() {
        return getLong(settlementAmount) - getLong(applyAmount) - getLong(refundingAmount) - getLong(refundedAmount);
    }

    /**
     * 预付款剩余可用金额
     * @return 剩余可用金额
     */
    public Long getSurplusAmount() {
        return getLong(receivedAmount) - getLong(deductionAmount) - getLong(refundingAmount);
    }

    private long getLong(Long num) {
        return num == null ? 0 : num;
    }
}
