package cn.com.duiba.quanyi.center.api.redis;

import cn.com.duiba.wolf.redis.RedisLock;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author lizhi
 * @date 2024/11/22 11:48
 */
@Slf4j
public class AutomaticRenewalRedisLock implements RedisLock {
    
    private StringRedisTemplate stringRedisTemplate;
    private String key;
    private String expectedValue;
    private long threadId;
    private volatile boolean running;
    
    private static final String COMPARE_AND_DELETE =
            "if redis.call('get',KEYS[1]) == ARGV[1]\n" +
                    "then\n" +
                    "    return redis.call('del',KEYS[1])\n" +
                    "else\n" +
                    "    return 0\n" +
                    "end";

    public AutomaticRenewalRedisLock(StringRedisTemplate stringRedisTemplate, String key, String expectedValue, long expireSeconds, long interval) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.key = key;
        this.expectedValue = expectedValue;
        threadId = Thread.currentThread().getId();
        running = true;
        new Thread(() -> {
            long intervalTime = TimeUnit.MILLISECONDS.convert(interval, TimeUnit.SECONDS);
            while (running) {
                try {
                    Thread.sleep(intervalTime);
                } catch (InterruptedException e) {
                    Thread.currentThread().isInterrupted();
                }
                stringRedisTemplate.expire(key, expireSeconds, TimeUnit.SECONDS);
                log.info("TestLog, expire, key={}, expireSeconds={}", key, expireSeconds);
            }
            log.info("TestLog, expire, end, key={}, expireSeconds={}", key, expireSeconds);
        }).start();
    }

    @Override
    public void unlock() {
        if(Thread.currentThread().getId() != threadId){
            //只允许创建锁的线程解锁
            throw new IllegalMonitorStateException();
        }
        running = false;
        List<String> keys = Collections.singletonList(key);
        stringRedisTemplate.execute(new DefaultRedisScript<>(COMPARE_AND_DELETE, Long.class), keys, expectedValue);
    }

    @Override
    public void close() throws Exception {
        this.unlock();
    }
}
