package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 业务活动类型
 * 对应于领取记录表的类型
 *
 * @author zzy
 * @create 2023/10/11 11:32
 **/
@Getter
@AllArgsConstructor
public enum BizActUrlEnum {
    BAI_MING_DAN(Collections.singletonList(1), "/pages/activity-manager/whitelist", "白名单领奖"),
    DUIBA_KAMI(Collections.singletonList(2), "/pages/activity-manager/dbkmpkg", "兑吧卡密包"),
    QUANYI_KAQUAN(Collections.singletonList(6), "/pages/activity-manager/coupon", "权益卡券包"),
    JIAN_HANG_ACTIVITY(Arrays.asList(3,4,5,9,14,24), "/pages/activity-manager/custom/ccb-activity", "建行活动"),
    API_SUPPLY(Collections.singletonList(7), "/pages/activity-manager/api/activity", "API供货"),
    ALI_TRAVEL_ACTIVITY(Collections.singletonList(17),"/pages/activity-manager/custom/alipay-travel","支付宝旅行活动"),
    GONG_HANG_ACTIVITY(Arrays.asList(8,10,12,13), "/pages/activity-manager/custom/icbc-activity", "工行活动"),
    HZ_BANK_MALL(Collections.singletonList(20),"/pages/activity-manager/custom/hzbank/integral-activity","杭州银行兑换活动"),
    MING_SHENG_ACTIVITY(Arrays.asList(19,25), "/pages/activity-manager/custom/msbank-activity", "民生银行"),
    CMB_RED_COINS(Collections.singletonList(26), "/pages/activity-manager/custom/cmb-activity","支付宝碰一下"),
    COLLECTION_PAGE(Collections.singletonList(27), "/pages/activity-manager/template-collection","集合页"),
    TEMPLATE_ACTIVITY(Arrays.asList(15,16,23), "/pages/activity-manager/template","模版活动"),
    MULTI_CHOICE_ONE(Collections.singletonList(28),"/pages/activity-manager/api/multi-choice-one", "多选一集合页"),
    API_SUPPLY_ACTIVITY(Collections.singletonList(21), "/pages/activity-manager/api/activity-active","API供货-活动"),
    COMMON_ACTIVITY(Arrays.asList(29,11), "/pages/new-activity/list","通用活动"),
    ;
    public static String getUrlByType(Integer type) {
        for (BizActUrlEnum typeEnum : values()) {
            if (typeEnum.getType().contains(type)) {
                return typeEnum.getUrl();
            }
        }
        return null;
    }

    private final List<Integer> type;

    private final String url;

    private final String desc;
}
