package cn.com.duiba.quanyi.center.api.enums.payment;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2025/9/21 22:35
 **/
@Getter
@AllArgsConstructor
public enum SupplierPaymentStatusEnum {
    // 1-初始化 2-创建中 3-创建成功（审批待提交） 4-创建失败 5-审批中 6-发起审批失败 7-审批通过 8-审批拒绝
    INITIALIZING(1, "初始化"),
    CREATING(2, "创建中"),
    CREATED(3, "创建成功（审批待提交）"),
    CREATE_FAILED(4, "创建失败"),
    APPROVING(5, "审批中"),
    APPROVE_FAILED(6, "发起审批失败"),
    APPROVED(7, "审批通过"),
    REJECTED(8, "审批拒绝");

    private final Integer status;

    private final String desc;
}
