package cn.com.duiba.quanyi.center.api.dto.refund;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 退款执行明细DTO
 *
 * @author yangyukang
 * @date 2025-01-21 15:30
 */
@Data
public class RefundTaskDetailDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 关联扫描任务主键
     */
    private Long scanTaskId;

    /**
     * 支付业务单号
     */
    private String paymentOrderNo;

    /**
     * 执行状态 0待执行, 1执行中, 2成功, 3失败
     * @see cn.com.duiba.quanyi.center.api.enums.RefundDetailStatusEnum
     */
    private Integer detailStatus;

    /**
     * 失败原因
     */
    private String failReason;
}
