package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2024/9/6 15:16
 **/
@Getter
@AllArgsConstructor
public enum RedEnableTimeTypeEnum {

    IMMEDIATELY(1, "立即生效"),

    NEXT_DAY(2, "次日生效"),

    FIXED_TIME(3, "固定时间生效");

    private final Integer type;

    private final String desc;

    public static RedEnableTimeTypeEnum getByType(Integer type) {
        for (RedEnableTimeTypeEnum item : RedEnableTimeTypeEnum.values()) {
            if (item.getType().equals(type)) {
                return item;
            }
        }
        return null;
    }
}
