package cn.com.duiba.quanyi.center.api.remoteservice.payment;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.payment.PaymentInfoSupplierDto;
import cn.com.duiba.quanyi.center.api.param.payment.PaymentInfoSupplierListParam;
import cn.com.duiba.quanyi.center.api.param.payment.SupplierPaymentSaveParam;

import java.util.List;

/**
 * 供应商付款远程服务接口
 * @author xuzhigang
 * @date 2025-09-17 16:20
 */
@AdvancedFeignClient
public interface RemotePaymentInfoSupplierService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 供应商付款
     */
    PaymentInfoSupplierDto selectById(Long id);

    /**
     * 根据主键集合批量查询
     * @param ids 主键集合
     * @return 供应商付款列表
     */
    List<PaymentInfoSupplierDto> selectByIds(List<Long> ids);

    /**
     * 根据供应商ID查询
     * @param supplierId 供应商ID
     * @return 供应商付款列表
     */
    List<PaymentInfoSupplierDto> selectBySupplierId(Long supplierId);

    /**
     * 根据供应商付款编号查询
     * @param supplierPaymentNo 供应商付款编号
     * @return 供应商付款
     */
    PaymentInfoSupplierDto selectBySupplierPaymentNo(String supplierPaymentNo);

    /**
     * 根据结算单ID查询
     * @param settlementId 结算单ID
     * @return 供应商付款
     */
    PaymentInfoSupplierDto selectBySettlementId(Long settlementId);

    /**
     * 根据付款ID查询
     * @param paymentId 付款ID
     * @return 供应商付款
     */
    PaymentInfoSupplierDto selectByPaymentId(Long paymentId);

    /**
     * 根据付款ID集合查询
     * @param paymentIds 付款ID集合
     * @return 供应商付款列表
     */
    List<PaymentInfoSupplierDto> selectByPaymentIds(List<Long> paymentIds);

    /**
     * 新增
     * @param dto 供应商付款
     * @return 主键
     */
    Long insert(PaymentInfoSupplierDto dto);

    /**
     * 批量新增
     * @param list 供应商付款列表
     * @return 执行结果
     */
    Integer batchInsert(List<PaymentInfoSupplierDto> list);

    /**
     * 更新
     * @param dto 供应商付款
     * @return 执行结果
     */
    Integer update(PaymentInfoSupplierDto dto);

    /**
     * 批量更新
     * @param list 供应商付款列表
     * @return 执行结果
     */
    Integer batchUpdate(List<PaymentInfoSupplierDto> list);

    /**
     * 逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    Integer delete(Long id);

    /**
     * 批量逻辑删除
     * @param ids 主键列表
     * @return 执行结果
     */
    Integer batchDelete(List<Long> ids);


    /**
     * 根据查询参数查询供应商付款列表
     * @param param 查询参数
     * @return 供应商付款列表
     */
    List<PaymentInfoSupplierDto> getByListParam(PaymentInfoSupplierListParam param);

    /**
     * 保存供应商付款
     *
     * @param param 供应商付款参数
     * @return 供应商付款ID
     * @throws BizException 业务异常
     */
    Long save(SupplierPaymentSaveParam param) throws BizException;

    /**
     * 更新状态
     * @param id 主键
     * @param fromStatus 旧状态
     * @param status 新状态
     * @return 执行结果
     */
    int updateStatus(Long id, Integer fromStatus, Integer status);
}
