package cn.com.duiba.quanyi.center.api.remoteservice.activity.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonUserInfoCacheDto;

import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/30 16:53
 */
@AdvancedFeignClient
public interface RemoteActivityCommonCacheService {

    /**
     * 查询活动下用户缓存
     * @param collectionPageId 集合页ID
     * @param activityId 活动ID
     * @param userId 用户ID
     * @param typeList 需要加载的缓存类型
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonCacheTypeEnum
     * @return 缓存对象
     */
    ActivityCommonUserInfoCacheDto getUserInfo(Long collectionPageId, Long activityId, Long userId, List<Integer> typeList);
}
