package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.api.BatchGenerateUrlTaskDto;
import cn.com.duiba.quanyi.center.api.param.api.BatchGenerateUrlTaskSearchParam;
import java.util.List;

/**
 * 批量生成短链任务
 * @author kjj mybatis generator
 * @date 2025-05-30
 */
@AdvancedFeignClient
public interface RemoteBatchGenerateUrlTaskService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 批量生成短链任务集合
     */
    List<BatchGenerateUrlTaskDto> selectPage(BatchGenerateUrlTaskSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(BatchGenerateUrlTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 批量生成短链任务
     */
    BatchGenerateUrlTaskDto selectById(Long id);

    /**
     * 新增
     * @param dto 批量生成短链任务
     * @return 执行结果
     */
    Long insert(BatchGenerateUrlTaskDto dto);

    /**
     * 更新
     * @param dto 批量生成短链任务
     * @return 影响行数
     */
    int update(BatchGenerateUrlTaskDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据唯一键查询
     * @param sendSerialNum 唯一键
     * @return 批量生成短链任务
     */
    BatchGenerateUrlTaskDto selectByUk(String sendSerialNum);

    /**
     * 更新状态
     * @param id 主键
     * @param taskStatus 状态
     * @return 影响行数
     */
    int updateStatus(Long id, Integer taskStatus);

}
