package cn.com.duiba.quanyi.center.api.enums;

import lombok.Getter;

/**
 * 退款业务类型枚举
 *
 * @author yangyukang
 * @date 2025-01-21 15:30
 */
@Getter
public enum RefundBusinessTypeEnum {

    /**
     * 活动退款
     */
    ACTIVITY_REFUND(1, "活动退款");

    private final Integer code;

    private final String desc;

    RefundBusinessTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据代码获取枚举
     *
     * @param code 代码
     * @return 枚举值
     */
    public static RefundBusinessTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (RefundBusinessTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }
}
