package cn.com.duiba.quanyi.center.api.dto.bill;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 账单统计表-批次维度
 * @author mybatis generator 
 * @date 2024-03-07
 */
@Data
public class BillStatisticStockDto implements Serializable {
     
    private static final long serialVersionUID = 17097957325468702L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 账单id tb_bill.id
     */
    private Long billId;

    /**
     * 批次id
     */
    private String stockId;

    /**
     * 统计日期 yyyy-mm-dd
     */
    private LocalDate curDate;

    /**
     * 核销金额
     */
    private Long writeOffAmount;

    /**
     * 核销笔数
     */
    private Integer writeOffNum;

    /**
     * 退款/退货金额 分
     */
    private Long refundAmount;

    /**
     * 退款/退货笔数
     */
    private Integer refundNum;

    /**
     * 实际核销金额 分
     */
    private Long realWriteOffAmount;

    /**
     * 实际核销笔数
     */
    private Integer realWriteOffNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}