package cn.com.duiba.quanyi.center.api.dto.goods;

import cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderSwitchEnum;
import cn.com.duiba.quanyi.center.api.utils.BitUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品库下单表
 * @author kjj mybatis generator 
 * @date 2023-09-14
 */
@Data
public class GoodsOrderDto implements Serializable {

    private static final long serialVersionUID = -1822734768972037695L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 商品库订单业务主键
     */
    private Long goodsBizId;

    /**
     * 商品库订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     */
    private Integer goodsBizType;

    /**
     * 业务单号
     */
    private String bizOrderNo;

    /**
     * 订单号
     */
    private String goodsOrderNo;

    /**
     * 规格ID
     */
    private Long skuId;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;
    
    /**
     * 订单价格，单位分
     */
    private Long orderPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 商品库订单号
     */
    private String orderNo;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 发放的批次表主键
     * 如：tb_wx_coupon.id
     * tb_alipay_activity.id
     */
    private Long couponId;

    /**
     * 活动类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 调用商品库发放参数
     */
    private String accountInfo;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 展示给前端的错误码
     */
    private String failCode;

    /**
     * 链接券-短链
     */
    private String shortUrl;

    /**
     * 短链失效时间
     */
    private Date shortUrlExpireTime;

    /**
     * 关联的code
     */
    private String refCode;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 发放方式：1-直充，2-短链
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 领取方式：1-单一领取，2-一键领取
     * @see cn.com.duiba.quanyi.center.api.enums.activity.TakeTypeEnum
     */
    private Integer takeType;

    /**
     * 批量领取订单Id
     */
    private Long batchOrderId;

    /**
     * 批量领取订单号
     */
    private String batchOrderNo;

    /**
     * 关联的需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 发放的面额
     */
    private Long couponAmount;

    /**
     * 是否已扣减库存
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer alreadySubStock;

    /**
     * 是否已经扣减奖品库存
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer alreadySubPrizeStock;

    /**
     * 关单原因
     */
    private String closeReason;

    /**
     * 业务主体
     * @deprecated 后续不在使用，保留兼容历史数据，后续使用extParam.duibaSubjectId
     */
    @Deprecated
    private Integer duibaSubject;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 最新extParam参数
     */
    private String extParam;

    /**
     * 订单开关
     */
    private Long orderSwitch;

    /**
     * 开关是否开启
     * @param switchEnum 开关枚举
     * @return true-开启
     */
    public boolean isOpen(GoodsOrderSwitchEnum switchEnum) {
        if (switchEnum == null || orderSwitch == null) {
            return false;
        }
        return BitUtils.isTrue(orderSwitch, switchEnum.getPosition());
    }

    /**
     * 打开开关
     * @param switchEnum 开关枚举
     */
    public void openSwitch(GoodsOrderSwitchEnum switchEnum) {
        if (switchEnum == null || switchEnum.getPosition() == null) {
            return;
        }
        long number = orderSwitch == null ? 0 : orderSwitch;
        orderSwitch = BitUtils.addBit(number, switchEnum.getPosition());
    }

    /**
     * 关闭开关
     * @param switchEnum 开关枚举
     */
    public void closeSwitch(GoodsOrderSwitchEnum switchEnum) {
        if (switchEnum == null || switchEnum.getPosition() == null) {
            return;
        }
        long number = orderSwitch == null ? 0 : orderSwitch;
        orderSwitch = BitUtils.removeBit(number, switchEnum.getPosition());
    }
}