package cn.com.duiba.quanyi.center.api.utils;

import org.apache.commons.collections4.CollectionUtils;

import java.util.List;

/**
 * @author lizhi
 * @date 2023/5/9 3:25 PM
 */
public class QuanYiStringUtils {
    
    private QuanYiStringUtils() {}
    
    public static String subStringIfAbsent(String str, int maxLength) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength);
    }
    
    public static String subStringAndAddLog(String str, int maxLength) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength - 1) + "...";
    }

    /**
     * list 转化为逗号分隔的string
     * @param list 输入
     * @return 输出
     */
    public static String StringlistToString(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return String.join(",", list);
    }
    
    public static String toStringAndAddZero(String idStr, int minLength) {
        if (idStr.length() >= minLength) {
            return idStr;
        }
        int needZeroNum = minLength - idStr.length();
        return getZero(needZeroNum) + idStr;
    }

    /**
     * 获取0
     *
     * @param num 需要的0的个数
     * @return 字符串
     */
    public static String getZero(int num) {
        if (num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; i++) {
            sb.append("0");
        }
        return sb.toString();
    }
}
