package cn.com.duiba.quanyi.center.api.param;

import cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 合同分页查询参数
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ContractDayanPageQueryParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 2285480466331336761L;

    /**
     * 合同id
     */
    private Long id;
    /**
     * 合同编号
     */
    private String contractCode;
    /**
     * 合作客户主键, tb_partner.id
     */
    private Long partnerId;

    /**
     * 创建人id
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 客户编号
     */
    private String salesContractNumber;

    /**
     * 合同类型
     * {@link cn.com.duiba.quanyi.center.api.enums.contract.ContractTypeEnum}
     */
    private Integer contractType;

    /**
     * 合同ID 创建日期+编号
     */
    private String contractNo;

    /**
     * 创建开始时间
     */
    private Date gmtCreateStart;

    /**
     * 创建结束时间
     */
    private Date gmtCreateEnd;

    /**
     * 客户主体
     */
    private String partnerSubject;

}
