package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;

import java.io.Serializable;

/**
 * 美团支付券绑定到需求商品参数
 */
@Data
public class MeiTuanBindDemandGoodsParam implements Serializable {

    private static final long serialVersionUID = 7430988836943173922L;
    /**
     * tb_meituan_coupon.id
     */
    private Long meiTuanCouponId;
    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 需求商品id
     */
    private Long demandGoodsId;

    /**
     * 退款结算截止日
     */
    private Integer settlementDeadlineDays;

    /**
     * 退款结算类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.SettlementDeadlineTypeEnum
     */
    private Integer settlementDeadlineType;

    /**
     * 需求商品的sku id
     */
    private Long skuId;

    /**
     * 项目id
     * tb_project.id
     */
    private Long projectId;
}
