package cn.com.duiba.quanyi.center.api.remoteservice.external;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.external.ExternalOrderDeleteDto;
import cn.com.duiba.quanyi.center.api.dto.external.ExternalOrderDto;
import cn.com.duiba.quanyi.center.api.param.external.ExternalOrderEsSearchParam;
import cn.com.duiba.quanyi.center.api.param.external.ExternalOrderSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Set;

/**
 * 外部订单
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteExternalOrderService {
    /**
     * 根据条件搜索外部订单id集合
     * @param param 搜索条件
     * @return 订单id集合
     */
    Pair<Long, List<Long>> search(ExternalOrderEsSearchParam param);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 外部订单集合
     */
    List<ExternalOrderDto> selectPage(ExternalOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ExternalOrderSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 外部订单
     */
    ExternalOrderDto selectById(Long id);

    /**
     * 根据主键集合查询
     * @param ids 主键集合
     * @return 外部订单集合
     */
    List<ExternalOrderDto> selectByIds(List<Long> ids);

    /**
     * 根据taskId查询 md5密文
     * @param channelId 渠道id
     * @param taskId 任务id
     * @param cipherTextList md5密文集合
     * @return md5密文集合
     */
    Set<String> selectCipherTextByTaskId(Long channelId, Long taskId,List<String> cipherTextList);

    /**
     * 批量新增
     * @param list 外部订单
     * @return 执行结果
     */
    boolean batchInsert(List<ExternalOrderDto> list);

    /**
     * 查询需要被删除的订单集合
     * @param channelId 渠道id
     * @param taskId 任务id
     * @param pageSize 每次取的个数
     * @return 订单集合
     */
    List<ExternalOrderDeleteDto> selectDeleteOrder(Long channelId, Long taskId, Integer pageSize);

    /**
     * 批量删除外部订单
     * @param ids 主键id集合
     * @return 删除条数
     */
    int batchDeleteExternalOrder(List<Long> ids);

    /**
     * 查询还在使用的外部订单批次号集合
     * @param couponIds 外部订单批次号集合
     * @return 外部订单批次号集合
     */
    List<Long> selectCouponList(List<Long> couponIds);

    /**
     * 根据渠道ID查询外部订单id
     * @param channelId 渠道ID
     * @return 外部订单id
     */
    Long selectIdByChannelId(Long channelId);
}