/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.contract;

import java.util.Arrays;

public enum PrepaymentMethodEnum {
    PLAN_30_50_20("30%-50%-20%", "3-5-2", 3),
    PLAN_30_30_40("30%-30%-40%", "3-3-4", 3),
    PLAN_80_20("80%-20%", "8-2", 2),
    PLAN_70_30("70%-30%", "7-3", 2),
    PLAN_30_70("30%-70%", "3-7", 2);

    private final String code;
    private final String desc;
    private final Integer paymentTimes;

    public static PrepaymentMethodEnum getByCode(String code) {
        if (code == null || code.isEmpty()) {
            return null;
        }
        for (PrepaymentMethodEnum e : PrepaymentMethodEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public static String getDescByCode(String code) {
        PrepaymentMethodEnum e = PrepaymentMethodEnum.getByCode(code);
        return e != null ? e.getDesc() : null;
    }

    public static boolean isValid(String code) {
        return PrepaymentMethodEnum.getByCode(code) != null;
    }

    public static PrepaymentMethodEnum[] getByPaymentTimes(Integer paymentTimes) {
        if (paymentTimes == null) {
            return PrepaymentMethodEnum.values();
        }
        return (PrepaymentMethodEnum[])Arrays.stream(PrepaymentMethodEnum.values()).filter(e -> e.getPaymentTimes().equals(paymentTimes)).toArray(PrepaymentMethodEnum[]::new);
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getPaymentTimes() {
        return this.paymentTimes;
    }

    private PrepaymentMethodEnum(String code, String desc, Integer paymentTimes) {
        this.code = code;
        this.desc = desc;
        this.paymentTimes = paymentTimes;
    }
}

