package cn.com.duiba.quanyi.center.api.remoteservice.mall.cart;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.cart.MallCartItemsDto;

import java.util.List;

/**
 * 购物车商品表
 *
 * @author zzy
 * @date 2025-12-03 20:39
 */
@AdvancedFeignClient
public interface RemoteMallCartItemsService {

    /**
     * 新增
     *
     * @param dto 购物车商品
     * @return 主键ID
     */
    Long insert(MallCartItemsDto dto);

    /**
     * 根据company_id、user_id查询
     *
     * @param companyId 公司ID
     * @param userId     用户ID
     * @return 购物车商品集合
     */
    List<MallCartItemsDto> selectByCompanyIdAndUserId(Long companyId, Long userId);

    /**
     * 更新
     *
     * @param dto 购物车商品
     * @return 影响行数
     */
    int update(MallCartItemsDto dto);

    /**
     * 删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据user_id、cart_id查询
     *
     * @param userId 用户ID
     * @param cartId 购物车ID
     * @return 购物车商品集合
     */
    List<MallCartItemsDto> selectByUserIdAndCartId(Long userId, Long cartId);

    /**
     * 根据user_id、cart_id删除
     *
     * @param userId 用户ID
     * @param cartId 购物车ID
     * @return 执行结果
     */
    int deleteByUserIdAndCartId(Long userId, Long cartId);
}

