package cn.com.duiba.quanyi.center.api.param.demand;

import lombok.Data;

import java.io.Serializable;

/**
 * 需求-付款信息汇总查询参数
 * @author xuzhigang
 * @date 2025-01-27
 */
@Data
public class DemandPaymentInfoSumParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 付款类型，1-垫资打款，2-预付款退款，3-保证金
     * @see cn.com.duiba.quanyi.center.api.enums.demand.PaymentPurposeEnum
     */
    private Integer paymentPurpose;

    /**
     * 业务组类型，1-权益，2-数字营销
     * @see cn.com.duiba.quanyi.center.api.enums.contract.BusinessGroupTypeEnum
     */
    private Integer businessGroup;

    /**
     * 创建人ID
     */
    private Long createOperatorId;
}
